module sbox1(address, result);
input  [5:0] address;
wire   [5:0] address;
output [3:0] result;
reg    [3:0] result;

wire [5:0] A;
assign A = {address[5], address[0], address[4:1]};

reg [3:0] row0;
reg [3:0] row1;
reg [3:0] row2;
reg [3:0] row3;

always @(A)
begin

   case ({A[3],A[2],A[1],A[0]})
    0:
      begin
         row0 = 14;
         row1 =  0;
         row2 =  4;
         row3 = 15;
      end
    1:
      begin
         row0 =  4;
         row1 = 15;
         row2 =  1;
         row3 = 12;
      end
    2:
      begin
         row0 = 13;
         row1 =  7;
         row2 = 14;
         row3 =  8;
      end
    3:
      begin
         row0 =  1;
         row1 =  4;
         row2 =  8;
         row3 =  2;
      end
    4:
      begin
         row0 =  2;
         row1 = 14;
         row2 = 13;
         row3 =  4;
      end
    5:
      begin
         row0 = 15;
         row1 =  2;
         row2 =  6;
         row3 =  9;
      end
    6:
      begin
         row0 = 11;
         row1 = 13;
         row2 =  2;
         row3 =  1;
      end
    7:
      begin
         row0 =  8;
         row1 =  1;
         row2 = 11;
         row3 =  7;
      end
    8:
      begin
         row0 =  3;
         row1 = 10;
         row2 = 15;
         row3 =  5;
      end
    9:
      begin
         row0 = 10;
         row1 =  6;
         row2 = 12;
         row3 = 11;
      end
   10:
      begin
         row0 =  6;
         row1 = 12;
         row2 =  9;
         row3 =  3;
      end
   11:
      begin
         row0 = 12;
         row1 = 11;
         row2 =  7;
         row3 = 14;
      end
   12:
      begin
         row0 =  5;
         row1 =  9;
         row2 =  3;
         row3 = 10;
      end
   13:
      begin
         row0 =  9;
         row1 =  5;
         row2 = 10;
         row3 =  0;
      end
   14:
      begin
         row0 =  0;
         row1 =  3;
         row2 =  5;
         row3 =  6;
      end
   15:
      begin
         row0 =  7;
         row1 =  8;
         row2 =  0;
         row3 = 13;
      end
   endcase

   case ({A[5],A[4]})
    0:
      result = row0;
    1:
      result = row1;
    2:
      result = row2;
    3:
      result = row3;
   endcase

end

endmodule

module sbox2(address, result);
input  [5:0] address;
wire   [5:0] address;
output [3:0] result;
reg    [3:0] result;

wire [5:0] A;
assign A = {address[5], address[0], address[4:1]};

reg [3:0] row0;
reg [3:0] row1;
reg [3:0] row2;
reg [3:0] row3;

always @(A)
begin

   case ({A[4],A[3],A[2],A[0]})
    0:
      begin
         row0 = 15;
         row1 =  8;
         row2 =  0;
         row3 =  7;
      end
    1:
      begin
         row0 =  1;
         row1 = 14;
         row2 = 14;
         row3 = 11;
      end
    2:
      begin
         row0 =  6;
         row1 =  3;
         row2 = 10;
         row3 = 13;
      end
    3:
      begin
         row0 = 11;
         row1 =  4;
         row2 =  4;
         row3 =  1;
      end
    4:
      begin
         row0 =  9;
         row1 =  2;
         row2 =  5;
         row3 = 12;
      end
    5:
      begin
         row0 =  7;
         row1 = 13;
         row2 =  8;
         row3 =  6;
      end
    6:
      begin
         row0 = 12;
         row1 =  5;
         row2 =  9;
         row3 =  2;
      end
    7:
      begin
         row0 =  0;
         row1 = 10;
         row2 =  3;
         row3 = 15;
      end
    8:
      begin
         row0 =  3;
         row1 =  4;
         row2 = 13;
         row3 = 10;
      end
    9:
      begin
         row0 = 13;
         row1 =  7;
         row2 =  8;
         row3 =  1;
      end
   10:
      begin
         row0 = 15;
         row1 =  8;
         row2 =  3;
         row3 =  4;
      end
   11:
      begin
         row0 =  2;
         row1 = 14;
         row2 = 15;
         row3 =  2;
      end
   12:
      begin
         row0 = 12;
         row1 =  1;
         row2 = 11;
         row3 =  7;
      end
   13:
      begin
         row0 =  0;
         row1 = 10;
         row2 =  6;
         row3 = 12;
      end
   14:
      begin
         row0 =  6;
         row1 = 11;
         row2 =  0;
         row3 = 14;
      end
   15:
      begin
         row0 =  9;
         row1 =  5;
         row2 =  5;
         row3 =  9;
      end
   endcase

   case ({A[5],A[1]})
    0:
      result = row0;
    1:
      result = row1;
    2:
      result = row2;
    3:
      result = row3;
   endcase

end

endmodule

module sbox3(address, result);
input  [5:0] address;
wire   [5:0] address;
output [3:0] result;
reg    [3:0] result;

wire [5:0] A;
assign A = {address[5], address[0], address[4:1]};

reg [3:0] row0;
reg [3:0] row1;
reg [3:0] row2;
reg [3:0] row3;

always @(A)
begin

   case ({A[5],A[2],A[1],A[0]})
    0:
      begin
         row0 = 10;
         row1 = 13;
         row2 =  1;
         row3 =  2;
      end
    1:
      begin
         row0 =  0;
         row1 =  7;
         row2 = 13;
         row3 =  8;
      end
    2:
      begin
         row0 =  9;
         row1 =  0;
         row2 = 12;
         row3 =  5;
      end
    3:
      begin
         row0 = 14;
         row1 =  9;
         row2 =  7;
         row3 = 14;
      end
    4:
      begin
         row0 =  6;
         row1 =  3;
         row2 = 11;
         row3 = 12;
      end
    5:
      begin
         row0 =  3;
         row1 =  4;
         row2 =  4;
         row3 = 11;
      end
    6:
      begin
         row0 = 15;
         row1 =  6;
         row2 =  2;
         row3 = 15;
      end
    7:
      begin
         row0 =  5;
         row1 = 10;
         row2 =  8;
         row3 =  1;
      end
    8:
      begin
         row0 = 13;
         row1 =  1;
         row2 = 11;
         row3 =  4;
      end
    9:
      begin
         row0 =  6;
         row1 = 10;
         row2 =  1;
         row3 = 15;
      end
   10:
      begin
         row0 =  4;
         row1 = 13;
         row2 =  2;
         row3 = 14;
      end
   11:
      begin
         row0 =  9;
         row1 =  0;
         row2 = 12;
         row3 =  3;
      end
   12:
      begin
         row0 =  8;
         row1 =  6;
         row2 =  5;
         row3 = 11;
      end
   13:
      begin
         row0 = 15;
         row1 =  9;
         row2 = 10;
         row3 =  5;
      end
   14:
      begin
         row0 =  3;
         row1 =  8;
         row2 = 14;
         row3 =  2;
      end
   15:
      begin
         row0 =  0;
         row1 =  7;
         row2 =  7;
         row3 = 12;
      end
   endcase

   case ({A[3],A[4]})
    0:
      result = row0;
    1:
      result = row1;
    2:
      result = row2;
    3:
      result = row3;
   endcase

end

endmodule

module sbox4(address, result);
input  [5:0] address;
wire   [5:0] address;
output [3:0] result;
reg    [3:0] result;

wire [5:0] A;
assign A = {address[5], address[0], address[4:1]};

reg [3:0] row0;
reg [3:0] row1;
reg [3:0] row2;
reg [3:0] row3;

always @(A)
begin

   case ({A[5],A[3],A[2],A[1]})
    0:
      begin
         row0 =  7;
         row1 = 13;
         row2 = 13;
         row3 =  8;
      end
    1:
      begin
         row0 = 14;
         row1 = 11;
         row2 =  3;
         row3 =  5;
      end
    2:
      begin
         row0 =  0;
         row1 =  6;
         row2 =  6;
         row3 = 15;
      end
    3:
      begin
         row0 =  9;
         row1 =  0;
         row2 = 10;
         row3 =  3;
      end
    4:
      begin
         row0 =  1;
         row1 =  4;
         row2 =  2;
         row3 =  7;
      end
    5:
      begin
         row0 =  8;
         row1 =  2;
         row2 =  5;
         row3 = 12;
      end
    6:
      begin
         row0 = 11;
         row1 =  1;
         row2 = 12;
         row3 = 10;
      end
    7:
      begin
         row0 =  4;
         row1 = 14;
         row2 = 15;
         row3 =  9;
      end
    8:
      begin
         row0 = 10;
         row1 =  3;
         row2 =  6;
         row3 = 15;
      end
    9:
      begin
         row0 =  9;
         row1 =  0;
         row2 =  0;
         row3 =  6;
      end
   10:
      begin
         row0 = 12;
         row1 = 10;
         row2 = 11;
         row3 =  1;
      end
   11:
      begin
         row0 =  7;
         row1 = 13;
         row2 = 13;
         row3 =  8;
      end
   12:
      begin
         row0 = 15;
         row1 =  9;
         row2 =  1;
         row3 =  4;
      end
   13:
      begin
         row0 =  3;
         row1 =  5;
         row2 = 14;
         row3 = 11;
      end
   14:
      begin
         row0 =  5;
         row1 = 12;
         row2 =  2;
         row3 =  7;
      end
   15:
      begin
         row0 =  8;
         row1 =  2;
         row2 =  4;
         row3 = 14;
      end
   endcase

   case ({A[0],A[4]})
    0:
      result = row0;
    1:
      result = row1;
    2:
      result = row2;
    3:
      result = row3;
   endcase

end

endmodule

module sbox5(address, result);
input  [5:0] address;
wire   [5:0] address;
output [3:0] result;
reg    [3:0] result;

wire [5:0] A;
assign A = {address[5], address[0], address[4:1]};

reg [3:0] row0;
reg [3:0] row1;
reg [3:0] row2;
reg [3:0] row3;

always @(A)
begin

   case ({A[3],A[2],A[1],A[0]})
    0:
      begin
         row0 =  2;
         row1 = 14;
         row2 =  4;
         row3 = 11;
      end
    1:
      begin
         row0 = 12;
         row1 = 11;
         row2 =  2;
         row3 =  8;
      end
    2:
      begin
         row0 =  4;
         row1 =  2;
         row2 =  1;
         row3 = 12;
      end
    3:
      begin
         row0 =  1;
         row1 = 12;
         row2 = 11;
         row3 =  7;
      end
    4:
      begin
         row0 =  7;
         row1 =  4;
         row2 = 10;
         row3 =  1;
      end
    5:
      begin
         row0 = 10;
         row1 =  7;
         row2 = 13;
         row3 = 14;
      end
    6:
      begin
         row0 = 11;
         row1 = 13;
         row2 =  7;
         row3 =  2;
      end
    7:
      begin
         row0 =  6;
         row1 =  1;
         row2 =  8;
         row3 = 13;
      end
    8:
      begin
         row0 =  8;
         row1 =  5;
         row2 = 15;
         row3 =  6;
      end
    9:
      begin
         row0 =  5;
         row1 =  0;
         row2 =  9;
         row3 = 15;
      end
   10:
      begin
         row0 =  3;
         row1 = 15;
         row2 = 12;
         row3 =  0;
      end
   11:
      begin
         row0 = 15;
         row1 = 10;
         row2 =  5;
         row3 =  9;
      end
   12:
      begin
         row0 = 13;
         row1 =  3;
         row2 =  6;
         row3 = 10;
      end
   13:
      begin
         row0 =  0;
         row1 =  9;
         row2 =  3;
         row3 =  4;
      end
   14:
      begin
         row0 = 14;
         row1 =  8;
         row2 =  0;
         row3 =  5;
      end
   15:
      begin
         row0 =  9;
         row1 =  6;
         row2 = 14;
         row3 =  3;
      end
   endcase

   case ({A[5],A[4]})
    0:
      result = row0;
    1:
      result = row1;
    2:
      result = row2;
    3:
      result = row3;
   endcase

end

endmodule

module sbox6(address, result);
input  [5:0] address;
wire   [5:0] address;
output [3:0] result;
reg    [3:0] result;

wire [5:0] A;
assign A = {address[5], address[0], address[4:1]};

reg [3:0] row0;
reg [3:0] row1;
reg [3:0] row2;
reg [3:0] row3;

always @(A)
begin

   case ({A[3],A[2],A[1],A[0]})
    0:
      begin
         row0 = 12;
         row1 = 10;
         row2 =  9;
         row3 =  4;
      end
    1:
      begin
         row0 =  1;
         row1 = 15;
         row2 = 14;
         row3 =  3;
      end
    2:
      begin
         row0 = 10;
         row1 =  4;
         row2 = 15;
         row3 =  2;
      end
    3:
      begin
         row0 = 15;
         row1 =  2;
         row2 =  5;
         row3 = 12;
      end
    4:
      begin
         row0 =  9;
         row1 =  7;
         row2 =  2;
         row3 =  9;
      end
    5:
      begin
         row0 =  2;
         row1 = 12;
         row2 =  8;
         row3 =  5;
      end
    6:
      begin
         row0 =  6;
         row1 =  9;
         row2 = 12;
         row3 = 15;
      end
    7:
      begin
         row0 =  8;
         row1 =  5;
         row2 =  3;
         row3 = 10;
      end
    8:
      begin
         row0 =  0;
         row1 =  6;
         row2 =  7;
         row3 = 11;
      end
    9:
      begin
         row0 = 13;
         row1 =  1;
         row2 =  0;
         row3 = 14;
      end
   10:
      begin
         row0 =  3;
         row1 = 13;
         row2 =  4;
         row3 =  1;
      end
   11:
      begin
         row0 =  4;
         row1 = 14;
         row2 = 10;
         row3 =  7;
      end
   12:
      begin
         row0 = 14;
         row1 =  0;
         row2 =  1;
         row3 =  6;
      end
   13:
      begin
         row0 =  7;
         row1 = 11;
         row2 = 13;
         row3 =  0;
      end
   14:
      begin
         row0 =  5;
         row1 =  3;
         row2 = 11;
         row3 =  8;
      end
   15:
      begin
         row0 = 11;
         row1 =  8;
         row2 =  6;
         row3 = 13;
      end
   endcase

   case ({A[5],A[4]})
    0:
      result = row0;
    1:
      result = row1;
    2:
      result = row2;
    3:
      result = row3;
   endcase

end

endmodule

module sbox7(address, result);
input  [5:0] address;
wire   [5:0] address;
output [3:0] result;
reg    [3:0] result;

wire [5:0] A;
assign A = {address[5], address[0], address[4:1]};

reg [3:0] row0;
reg [3:0] row1;
reg [3:0] row2;
reg [3:0] row3;

always @(A)
begin

   case ({A[3],A[2],A[1],A[0]})
    0:
      begin
         row0 =  4;
         row1 = 13;
         row2 =  1;
         row3 =  6;
      end
    1:
      begin
         row0 = 11;
         row1 =  0;
         row2 =  4;
         row3 = 11;
      end
    2:
      begin
         row0 =  2;
         row1 = 11;
         row2 = 11;
         row3 = 13;
      end
    3:
      begin
         row0 = 14;
         row1 =  7;
         row2 = 13;
         row3 =  8;
      end
    4:
      begin
         row0 = 15;
         row1 =  4;
         row2 = 12;
         row3 =  1;
      end
    5:
      begin
         row0 =  0;
         row1 =  9;
         row2 =  3;
         row3 =  4;
      end
    6:
      begin
         row0 =  8;
         row1 =  1;
         row2 =  7;
         row3 = 10;
      end
    7:
      begin
         row0 = 13;
         row1 = 10;
         row2 = 14;
         row3 =  7;
      end
    8:
      begin
         row0 =  3;
         row1 = 14;
         row2 = 10;
         row3 =  9;
      end
    9:
      begin
         row0 = 12;
         row1 =  3;
         row2 = 15;
         row3 =  5;
      end
   10:
      begin
         row0 =  9;
         row1 =  5;
         row2 =  6;
         row3 =  0;
      end
   11:
      begin
         row0 =  7;
         row1 = 12;
         row2 =  8;
         row3 = 15;
      end
   12:
      begin
         row0 =  5;
         row1 =  2;
         row2 =  0;
         row3 = 14;
      end
   13:
      begin
         row0 = 10;
         row1 = 15;
         row2 =  5;
         row3 =  2;
      end
   14:
      begin
         row0 =  6;
         row1 =  8;
         row2 =  9;
         row3 =  3;
      end
   15:
      begin
         row0 =  1;
         row1 =  6;
         row2 =  2;
         row3 = 12;
      end
   endcase

   case ({A[5],A[4]})
    0:
      result = row0;
    1:
      result = row1;
    2:
      result = row2;
    3:
      result = row3;
   endcase

end

endmodule

module sbox8(address, result);
input  [5:0] address;
wire   [5:0] address;
output [3:0] result;
reg    [3:0] result;

wire [5:0] A;
assign A = {address[5], address[0], address[4:1]};

reg [3:0] row0;
reg [3:0] row1;
reg [3:0] row2;
reg [3:0] row3;

always @(A)
begin

   case ({A[3],A[0],A[5],A[2]})
    0:
      begin
         row0 = 13;
         row1 =  8;
         row2 =  1;
         row3 = 13;
      end
    1:
      begin
         row0 =  6;
         row1 = 11;
         row2 = 10;
         row3 =  7;
      end
    2:
      begin
         row0 =  7;
         row1 =  4;
         row2 =  2;
         row3 = 14;
      end
    3:
      begin
         row0 =  9;
         row1 = 14;
         row2 =  4;
         row3 =  8;
      end
    4:
      begin
         row0 =  2;
         row1 =  4;
         row2 = 15;
         row3 =  8;
      end
    5:
      begin
         row0 = 15;
         row1 =  1;
         row2 =  3;
         row3 =  4;
      end
    6:
      begin
         row0 = 11;
         row1 =  1;
         row2 =  1;
         row3 =  7;
      end
    7:
      begin
         row0 = 12;
         row1 =  2;
         row2 = 10;
         row3 = 13;
      end
    8:
      begin
         row0 = 10;
         row1 =  3;
         row2 = 12;
         row3 =  6;
      end
    9:
      begin
         row0 =  5;
         row1 = 12;
         row2 =  0;
         row3 =  9;
      end
   10:
      begin
         row0 =  0;
         row1 = 10;
         row2 = 15;
         row3 =  9;
      end
   11:
      begin
         row0 = 15;
         row1 =  5;
         row2 =  3;
         row3 =  6;
      end
   12:
      begin
         row0 =  9;
         row1 = 14;
         row2 =  5;
         row3 = 11;
      end
   13:
      begin
         row0 =  0;
         row1 =  7;
         row2 = 14;
         row3 =  2;
      end
   14:
      begin
         row0 =  6;
         row1 = 13;
         row2 = 12;
         row3 =  0;
      end
   15:
      begin
         row0 =  3;
         row1 =  8;
         row2 =  5;
         row3 = 11;
      end
   endcase

   case ({A[4],A[1]})
    0:
      result = row0;
    1:
      result = row1;
    2:
      result = row2;
    3:
      result = row3;
   endcase

end

endmodule

// **ends
